/*******************************************************************************
* mmPlayer.js
*
* Provides common interface for usage of the Adobe Flash Player
*
*******************************************************************************/

/*******************************************************************************
* Include required js files
* dataExchange.js - used for communication with application
* flashobject.js  - wraps the flashplayer as a javascript object
*******************************************************************************/
document.write('<script type="text/javascript" src="../common/dataExchange.js"></script>');
document.write('<script type="text/javascript" src="../common/flashobject.js"></script>');

/*******************************************************************************
* Default vars
*******************************************************************************/
var kRequiredFlashVersion = 7;                  // default flash version
var kLocalW               = 320;                // default LOCAL width
var kLocalH               = 310;                // default LOCAL height
var kStreamW              = 341;                // default STREAM width
var kStreamH              = 290;                // default STREAM height

/*******************************************************************************
* Global Vars
*
* 'set' by this wrapper
*******************************************************************************/
var gRequiredPlayerInstalled = false;
var gbLocal = false;

/*******************************************************************************
* doInternetInstallPrep()
* Don't use any pre-existing browser window that the user may have open. Instead,
* create one specifically for the flash installation. Once we create the window,
* call App install utility - IC GoToURL is then called which will always use
* 'last' browser window opened.
*******************************************************************************/
var flashInstallWin = "";
function doInternetInstall()
{
   try
   {
      if (flashInstallWin == "" || flashInstallWin.closed ) {
         flashInstallWin=window.open('','flashInstall','scrollbars=1,resizable=1,height=600,width=800,screenX=0,screenY=0,left=0,top=0');
         var doc = flashInstallWin.document;
         doc.write('<html><head>');
         doc.write('<style>body{ margin:20px; margin-right:30px; background:#efefef; color:black; font:13px Tahoma,Verdana,Arial;}</style>');
         doc.write('</head><body>');
         doc.write('<p style="margin-top: 15; margin-bottom: 0"><b><font size="4">Connecting to the Adobe Flash Player Download Center...</font></b></p>');
         doc.write('</body></html>');
         doc.close();
         parent.onCmd( "doInstallMediaPlayer" );
      }
      else
      {
         flashInstallWin.focus();
      }
   }
   catch (exc) {}
}

/*******************************************************************************
* doInstallMediaPlayer()
* Calls back into the application to install the player - how install is initiated
* is based on whether or not local vs. streaming
*******************************************************************************/
function doInstallMediaPlayer()
{
   try
   {
      if (gbLocal)
      {
         parent.onCmd( "doInstallMediaPlayer" );
      }
      else
      {
         doInternetInstall();
      }
   }
   catch (exc) {}
}

/*******************************************************************************
* doPromptForCD()
* Prompt user for CD...called when local media is NOT accessible
*******************************************************************************/
function doPromptForCD()
{
   try
   {
      parent.onCmd( "doPromptForCD" );
   }
   catch (exc) {}
}

/*******************************************************************************
* isLocalMedia()
* Returns true/false
* true - video content will be played from local media
* false - video content is via streaming/internet
*******************************************************************************/
function isLocalMedia()
{
   try
   {
      parent.onCmd( "getIsLocalMedia" );
      return(parent.getLastCmdResult()=="true"?true:false);
   }
   catch (exc) {}
   return false; // always return something to avoid "undefined" error
}

/*******************************************************************************
* isMediaAccessible()
* Returns whether or not the media is accessible
*******************************************************************************/
function isMediaAccessible(media,path)
{
   try
   {
      parent.setDataSrcItem( "mediaIsAccessible", media );
      parent.setDataSrcItem( "mediaPath", path );
      parent.onCmd( "getIsMediaAccessible" );
      return(parent.getLastCmdResult()=="true"?true:false);
   }
   catch (exc) {}
   return false; // always return something to avoid "undefined" error
}

/*******************************************************************************
* getMediaPath()
* Returns string value for media path. Local path (i.e. CD) or URL to internet
*******************************************************************************/
function getMediaPath()
{
   try
   {
      parent.onCmd( "getMediaPath" );
      return(parent.getLastCmdResult());
   }
   catch (exc) {}
   return ""; // always return something to avoid "undefined" error
}

/*******************************************************************************
* renderFlashPlayer(v,id,w,h)
* Wraps the creation of the flash player
* v  - (required) video to play
* id - (required) DIV id where player will be rendered to.
*
* return value
* true/false - success/failure
*******************************************************************************/
function renderFlashPlayer(v,id,w,h)
{
   var bSuccess = false;

   try
   {
      // initialize the id with the 'no flash player' html - will be removed
      // upon creation of valid player
      replaceTextById(id,getNoFlashPlayerHTML());

      // is local media? (else streaming...)
      gbLocal = isLocalMedia();

      // media path - local path (i.e. CD or internet URL)
      var p = getMediaPath();

      // Player width/height. Use defaults or client provided
      var width = (!w?(gbLocal?kLocalW:kStreamW):w);
      var height = (!h?(gbLocal?kLocalH:kStreamH):h);

      // build media to view -- local file or streaming content
      var mediaToView = "";
      if (gbLocal)
      {
         // path + file name + extension
         mediaToView = p+"\\"+v+".swf";
      }
      else
      {
         // base url tacked on to required additional info
         mediaToView = "http://"+p+"/fcs-tools/FLVPlayer.swf";
         mediaToView+= "?skinName=http://"+p+"/fcs-tools/haloSkin_3";
         mediaToView+= "&serverName=cp16746.edgefcs.net";
         mediaToView+= "&fallbackServerName=cp16746.edgefcs.net";
         mediaToView+= "&appName=ondemand";
// TYCO CY
         mediaToView+= "&streamName=/16746/CTG/TY06/"+v+"low, 50, /16746/CTG/TY06/"+v+"low, 200, ";
// TYCO CY
         mediaToView+= "/16746/CTG/TY06/"+v+"hi";
         mediaToView+= "&isLive=false&bufferTime=2&autoPlay=true&autoRewind=true&isFullScreen=false";
      }

      // check if media is accessible - if yes, create the flash object
      if (isMediaAccessible(mediaToView,p))
      {
         var fo = new FlashObject(mediaToView,"FLVPlayer",width,height,kRequiredFlashVersion,"#FFFFFF");
         if (gbLocal)
         {
            fo.addParam("allowScriptAccess","sameDomain");
         }
         else
         {
            fo.addParam("salign","lt");
            fo.addParam("scale","noscale");
         }
         fo.addParam("menu",false);
         fo.write(id);
      }
      else
      {
         // display appropriate bitmap image - prompt user to insert CD
         // if local content
         mediaNotAccessible((v+".swf"),gbLocal,id,width,height);
      }
   } catch (exc) {}

   return bSuccess;
}

/*******************************************************************************
* mediaNotAccessible(v,localMedia,elementId,w,h)
* Used if specified video image cannot be located - written to elementId
* specified.
* v            - the video name
* localMedia   - true/false. Is the media local (cd) or streamed (internet)
* elementId    - where is the message rendered to
* w,h          - width/height of area
*******************************************************************************/
function mediaNotAccessible(v,localMedia,elementId,w,h)
{
   // render our message that the media is not accessible
   var s = '<IMG id="mediaNotAccessible" src="../img/unavailable';
   s+= (localMedia?'cd':'stream')+'.jpg"';
   s+= 'width="'+w+'"';
   s+= ' height="'+h+'" border="0">';
   replaceTextById(elementId,s);
   if (localMedia)
   {
      // set the filename to data src so app knows
      parent.setDataSrcItem( "mediaFilename", v);
      // prompt the user for the cd
      doPromptForCD();
   }
}

/*******************************************************************************
* getNoFlashPlayerHTML()
* Returns html to be used when no flash player is detected
*
*******************************************************************************/
function getNoFlashPlayerHTML()
{
   var noFlashPlayerHTML = "";
   noFlashPlayerHTML += '<table style="BORDER=3px ridge cornflowerblue;" width="100%">';
   noFlashPlayerHTML += '<tr>';
   noFlashPlayerHTML += '<td>';
   noFlashPlayerHTML += '<H5>You don\'t have the latest version of Adobe Flash Player</H5>';
   noFlashPlayerHTML += '</td>';
   noFlashPlayerHTML += '</tr>';
   noFlashPlayerHTML += '<tr>';
   noFlashPlayerHTML += '<td>';
   noFlashPlayerHTML += '<TABLE height="52" cellSpacing="1" cellPadding="1" border="0">';
   noFlashPlayerHTML += '<TR>';
   noFlashPlayerHTML += '<TD>';
   noFlashPlayerHTML += '<FONT size="2">You need the latest version of Adobe Flash Player to view our ';
   noFlashPlayerHTML += 'videos. Select the button to install it now (this will only take a moment).<br></FONT>';
   noFlashPlayerHTML += '<FONT size="1">Adobe and Flash are trademarks of Adobe Systems Inc.</FONT>';
   noFlashPlayerHTML += '</TD>';
   noFlashPlayerHTML += '<TD vAlign="top">';
   noFlashPlayerHTML += '<IMG height="31" id="InstallFlash" src="../img/flash_get_flashplayer_88_31.gif"';
   noFlashPlayerHTML += 'width="88" border="0" onclick="doInstallMediaPlayer()" style="CURSOR:hand">';
   noFlashPlayerHTML += '</TD>';
   noFlashPlayerHTML += '</TR>';
   noFlashPlayerHTML += '</TABLE>';
   noFlashPlayerHTML += '</td> ';
   noFlashPlayerHTML += '</tr>';
   noFlashPlayerHTML += '</table>';
   return noFlashPlayerHTML;
}


